package rozwiazania_zadan.r1.z07_skarb;

import java.util.Random;
import java.util.Scanner;

/*
Napisz grę polegającą na poszukiwaniu skarbu na dwuwymiarowej planszy o rozmiarach 10 na 10.
Plansza jest wirtualna - nie trzeba ani w pamięci tworzyć żadnych tablic, ani żadnej planszy wyświetlać :)

Program na początku losuje położenie skarbu na planszy (współrzędne x i y)
oraz początkowe położenie gracza.

Następnie w pętli użytkownik może wprowadzać komendy zmieniające położenie gracza.
(np. po polsku G D L P, albo po angielsku U D L R, albo konwencja graczy W S A D)

Po każdym ruchu użytkownik powinien otrzymywać informację o tym, czy zmierza w dobrym kierunku.

Wyjście poza planszę oznacza porażkę - koniec gry.
Wejście przez gracza na pozycję skarbu oznacza wygraną.

Po znalezieniu skarbu program wypisuje gratulacje i informację o liczbie ruchów
wykorzystanych przez użytkownika na dojście do celu.
*/

public class GraSzukanieSkarbu {
	private static final boolean PODPOWIADANIE = true;

	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in); // aby czytać polecenia
		Random random = new Random(); // aby losować
		
		int skarb_x = random.nextInt(10); // liczba od 0 do 9
		int skarb_y = random.nextInt(10);
		int gracz_x = random.nextInt(10);
		int gracz_y = random.nextInt(10);

		if(PODPOWIADANIE)
			System.out.printf("Pozycja skarbu: (%d , %d)\n", skarb_x, skarb_y);

		petla:
		while(true) {
			if(PODPOWIADANIE)
				System.out.printf("\nAktualna pozycja: (%d , %d)\n", gracz_x, gracz_y);
			
			int staraOdleglosc = Math.abs(skarb_x - gracz_x) + Math.abs(skarb_y - gracz_y);
			
			System.out.println("Podaj ruch [WSAD] lub przerwij [Q]: ");
			String ruch = sc.nextLine();
			
			switch(ruch.trim().toUpperCase()) {
			case "W" : gracz_y--; break;
			case "S" : gracz_y++; break;
			case "A" : gracz_x--; break;
			case "D" : gracz_x++; break;
			case "Q" : 
				System.out.println("Poddajesz się? miękiszon...");
				break petla; // mówimy, że break odnosi się do pętli oznaczonej tą etykietą
				
			default:
				System.out.println("nie ma takiej komendy");
				continue petla; // etykiety można podawać także przy instrukcji continue, chociaż w tym konkretnym przypadku nie jest to konieczne
			}
			
			if(gracz_x < 0 || gracz_x > 9 || gracz_y < 0 || gracz_y > 9) {
				System.out.println("Wypadłeś poza planszę - porażka");
				break;
			}
			
			if(gracz_x == skarb_x && gracz_y == skarb_y) {
				System.out.println("Wygrana, gratulacje!");
				break;
			}
			
			int nowaOdleglosc = Math.abs(skarb_x - gracz_x) + Math.abs(skarb_y - gracz_y);
			// System.out.println("odległość: " + nowaOdleglosc);
			if(nowaOdleglosc < staraOdleglosc) {
				System.out.println("Zbliżasz się do skarbu");
			} else {
				System.out.println("Oddalasz się od skarbu");
			}
		}
		
		System.out.println("\n================================\n  To była gra napisania na kursie ALX\n================================");
	}
}
