package pracownicy;

import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class P8a_Podwyzka {

	public static void main(String[] args) {
		JFileChooser chooser = new JFileChooser(".");
		chooser.setDialogTitle("Wybierz plik z danymi");
		chooser.setFileFilter(new FileNameExtensionFilter("Pliki CSV", "csv", "txt"));
		
		int coSieStalo = chooser.showOpenDialog(null);
		if(coSieStalo != JFileChooser.APPROVE_OPTION) {
			// użytkownik kliknął Cancel lub doszło do błędu
			return;
		}
		// Wiemy teraz, że metoda zakończyła się sukcesem (APPROVE_OPTION)
		// i w poniższy sposób pobieramy dane wskazanego pliku:
		File wejscie = chooser.getSelectedFile();
		List<Employee> emps = ObslugaCSV.wczytaj(wejscie);
		
		// Zbierzmy zestaw stanowisk bez powtórzeń. Użyjemy do tego Set
		Set<String> jobs = new TreeSet<>();
		for(Employee emp : emps) {
			jobs.add(emp.getJobTitle());
		}
		
		String job = (String)JOptionPane.showInputDialog(null,
				"Kto ma dostać podwyżkę?", "Wybierz stanowisko", JOptionPane.QUESTION_MESSAGE,
				null, jobs.toArray(), "President");
				
		int podwyzka = Integer.parseInt(JOptionPane.showInputDialog("Podaj kwotę podwyżki"));
		
		int ile = 0;
		for (Employee emp : emps) {
			if (emp.getJobTitle().equals(job)) {
				emp.setSalary(emp.getSalary() + podwyzka);
				ile++;
			}
		}

		JOptionPane.showMessageDialog(null, "Zmieniono " + ile + " rekordów.");
		
		coSieStalo = chooser.showSaveDialog(null);
		if(coSieStalo != JFileChooser.APPROVE_OPTION) {
			// użytkownik kliknął Cancel lub doszło do błędu
			return;
		}
		File wyjscie = chooser.getSelectedFile();
		if(wyjscie.exists()) {
			coSieStalo = JOptionPane.showConfirmDialog(null, "Plik istnieje. Czy chcesz go zastąpić?", "Uwaga", JOptionPane.YES_NO_OPTION);
			if(coSieStalo == JOptionPane.NO_OPTION) {
				return;
			}
		}
		
		ObslugaCSV.zapisz(emps, wyjscie);
		JOptionPane.showMessageDialog(null, "Gotowe");
	}

}
