package pracownicy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Używamy operacji dodanej w Java 8 : merge
// To jest operacja, która implementuje schemat pokazywany w wersji 2.

public class Grupowanie5 {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("pracownicy.csv");
		
		Map<String, Integer> sumy = new HashMap<>();
		Map<String, Integer> ilosci= new HashMap<>();
		
		for (Employee emp : emps) {
			sumy.merge(emp.getJobTitle(), emp.getSalary(), Integer::sum);
			ilosci.merge(emp.getJobTitle(), 1, Integer::sum);
			// merge dla podanego klucza (miejsca w słowniku) robi tak:
			// - jeśli jeszcze niczego nie ma, to wstawia wartość 2 parametru (np. salary)
			// - jeśli już coś jest, to starą wartość aktualizuje za pomocą funkcji dodanej w 3 parametrze (tutaj: dodawania)
			//   z wykorzystaniem wartości podanej w drugim parametrze
		}
		
		for(String job : sumy.keySet()) {
			int suma = sumy.get(job);
			int ilosc = ilosci.get(job);
			double srednia = 1.0 * suma / ilosc;
			System.out.printf("|%32s | %2d | %8.2f |\n", job, ilosc, srednia);
		}
	}

}
