package pracownicy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Używamy operacji dodanej w Java 8 : getOrDefault
public class Grupowanie3 {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("pracownicy.csv");
		
		Map<String, Integer> sumy = new HashMap<>();
		Map<String, Integer> ilosci= new HashMap<>();
		
		for (Employee emp : emps) {
			int dotychczasowaSuma = sumy.getOrDefault(emp.getJobTitle(), 0);
			sumy.put(emp.getJobTitle(), dotychczasowaSuma + emp.getSalary());
			int dotychczasowaIlosc = ilosci.getOrDefault(emp.getJobTitle(), 0);
			ilosci.put(emp.getJobTitle(), dotychczasowaIlosc+1);
		}
		
		for(String job : sumy.keySet()) {
			int suma = sumy.get(job);
			int ilosc = ilosci.get(job);
			double srednia = 1.0 * suma / ilosc;
			System.out.printf("|%32s | %2d | %8.2f |\n", job, ilosc, srednia);
		}
	}

}




