package pracownicy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

// To jest klasyczny algorytm grupowania / agregacji z wykorzystaniem słowników.
// To rozwiązanie jest bardziej wydajne niż v1, bo tylko jeden raz przeglądamy listę pracowników,
// a operacje na słownikach (odczyt, zapis, sprawdzanie) są szybkie.
// Tutaj używamy tylko operacji dostępnych w starych wersjach Javy, co najmniej od Javy 5.
public class Grupowanie2a {

	public static void main(String[] args) {
		final List<Employee> emps = ObslugaCSV.wczytaj("pracownicy.csv");
		
		final Map<String, Integer> sumy = new HashMap<>();
		final Map<String, Integer> ilosci= new HashMap<>();
		
		for (Employee emp : emps) {
			final String jobTitle = emp.getJobTitle();
			if (sumy.containsKey(jobTitle)) {
				// już wcześniej występowali pracownicy z tego stanowiska
				// trzeba odczytać dotychczasową wartość i zapisać powiększoną
				int dotychczasowaSuma = sumy.get(jobTitle);
				sumy.put(jobTitle, dotychczasowaSuma + emp.getSalary());
				int dotychczasowaIlosc = ilosci.get(jobTitle);
				ilosci.put(jobTitle, dotychczasowaIlosc + 1);
			} else {
				// to jest pierwszy pracownik z danego stanowiska
				sumy.put(jobTitle, emp.getSalary());
				ilosci.put(jobTitle, 1);
			}
		}
		
//		System.out.println(sumy);
//		System.out.println(ilosci);
		
		for(String job : sumy.keySet()) {
			int suma = sumy.get(job);
			int ilosc = ilosci.get(job);
			double srednia = 1.0 * suma / ilosc;
			System.out.printf("|%32s | %2d | %8.2f |\n", job, ilosc, srednia);
		}
	}

}
