package emps.strumieniowo;

import java.util.List;
import java.util.stream.Collectors;

public class P3_SredniaWszystkich {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		// sposób pierwszy: mapujemy na IntStream i korzystamy z gotowej operacji average
		double srednia = emps.stream()
				.mapToInt(Employee::getSalary)
				.average()
				.orElse(0.0);
		System.out.println("Średnia wszystkich v1: " + srednia);
		
		// sposób drugi: użyć dedykowanego "collectora"
		double srednia2 = emps.stream().collect(Collectors.averagingInt(Employee::getSalary));
		System.out.println("Średnia wszystkich v2: " + srednia2);
	}

}
