package emps.obiektowo;

import java.util.List;

public class P5_MinMax_v1 {
	// Program znajduje pracownika, który zarabia najwięcej, i pracownika, który zarabia najmniej,
	// i wypisuje ich dane (co najmniej: imię, nazwisko, pensję).

	// W tej wersji najpierw ustalę jaka jest minimalna i maksymalna pensja, a dopiero potem kto tyle zarabia
	// Zaleta: gdyby kilka osób miało jednakową pensję (np. nie tylko King zarabiał 24 tys),
	// to wszystkie takie osoby się wypiszą.
	
	// Wada: dane z lisy przeglądamy kilka razy.

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		int minSalary = Integer.MAX_VALUE;
		int maxSalary = Integer.MIN_VALUE;
		for(Employee emp : emps) {
			if(emp.getSalary() > maxSalary) {
				maxSalary = emp.getSalary();
			}
			if(emp.getSalary() < minSalary) {
				minSalary = emp.getSalary();
			}
		}
		
		System.out.println("Maksymalna pensja wynosi " + maxSalary);
		System.out.println("Kto tyle zarabia?");
		for(Employee emp : emps) {
			if(emp.getSalary() == maxSalary) {
				System.out.println(emp.getFirstName() + " " + emp.getLastName());
			}
		}
		System.out.println();
		
		System.out.println("Minimalna pensja wynosi " + minSalary);
		System.out.println("Kto tyle zarabia?");
		for(Employee emp : emps) {
			if(emp.getSalary() == minSalary) {
				System.out.println(emp.getFirstName() + " " + emp.getLastName());
			}
		}
		
	}

}
