package emps.obiektowo;

import java.io.File;
import java.util.List;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class P4a_SredniaWybranych_Interaktywnie {
// W tej wersji uzytkownik będzie mógł wybrać plik z dysku i wskazać stanowisko, dla którego ma być wylicozna średnia.
	
	public static void main(String[] args) {
		JFileChooser chooser = new JFileChooser(".");
		chooser.setDialogTitle("Wybierz plik z danymi pracowników");
		chooser.setFileFilter(new FileNameExtensionFilter("Plii CSV", "csv", "txt"));
		int coSieStalo = chooser.showOpenDialog(null);
		if(coSieStalo != JFileChooser.APPROVE_OPTION) {
			return;
		}
		File wybranyPlik = chooser.getSelectedFile();
		
		List<Employee> emps = ObslugaCSV.wczytaj(wybranyPlik);
		
		String wybranyJob = JOptionPane.showInputDialog("Podaj nazwę stanowiska:");
		
		double suma = 0;
		int ile = 0;
		for (Employee emp : emps) {
			if(emp.getJobTitle().equalsIgnoreCase(wybranyJob)) {
				suma += emp.getSalary();
				ile++;
			}
		}

		double srednia = suma / ile;
		JOptionPane.showMessageDialog(null, "Średnia pensja na stanowisku " + wybranyJob + " wynosi " + srednia);
	}

}
