package emps.obiektowo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Grupowanie4 {
	// Tutaj używamy operacji z zaszytym ifem i nie musimy pisać ifa
	// Do operacji typu compute przekauzje się funkcję, która ma za zadanie zaktualizować wartość w słowniku.
	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		Map<String, Integer> sumy = new HashMap<>();
		Map<String, Integer> ilosci = new HashMap<>();
		
		for(Employee emp : emps) {
			sumy.putIfAbsent(emp.getJobTitle(), 0);
			sumy.computeIfPresent(emp.getJobTitle(), (k, v) -> v + emp.getSalary());
			
			ilosci.putIfAbsent(emp.getJobTitle(), 0);
			ilosci.computeIfPresent(emp.getJobTitle(), (k, v) -> v + 1);
		}
		
		for(String job : sumy.keySet()) {
			int suma = sumy.get(job);
			int ile = ilosci.get(job);
			double srednia = (double)suma / ile;
			System.out.printf("| %-32s | %2d | %8.2f |\n", job, ile, srednia);
		}
	}
}
