package kalkulator;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet("/Kalkulator3")
public class Kalkulator3 extends HttpServlet {
	private static final long serialVersionUID = 1L;
	
	// W tej wersji wyświeltenie pustego formularza jest realizowane metodą GET,
	// o obsługa wypełnionego formularza, czyli obliczenie i podanie wyniku, metodą POST.
	
	// Możemy oddzielnie zaimplementować metody GET i POST w metodach serwletu:

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/html");
		response.setCharacterEncoding("utf-8");
		PrintWriter out = response.getWriter();
		
		out.println("<!DOCTYPE html>");
		out.println("<html>");
		out.println("<head>");
		out.println("<title>Kalkulator serwletowy</title>");
		out.println("<link rel='stylesheet' type='text/css' href='styl.css'>");
		out.println("</head>");
		out.println("<body>");
		out.println("<h1>Kalkulator 3</h1>");
		out.println("<form method='post'>");
		out.println("<p>Wpisz liczby i wybierz działanie:</p>");		
		out.println("<input name='liczba1' type='number'>");
		out.println("<select name='operacja'>");
		out.println("<option value='+'>+</option>");
		out.println("<option value='-'>-</option>");
		out.println("<option value='*'>*</option>");
		out.println("<option value='/'>/</option>");
		out.println("</select>");		
		out.println("<input name='liczba2' type='number'>");
		out.println("<button>=</button>");
		out.println("</form>");
		out.println("</body>");
		out.println("</html>");
	}
	
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/html");
		response.setCharacterEncoding("utf-8");
		PrintWriter out = response.getWriter();
		
		out.println("<!DOCTYPE html>");
		out.println("<html>");
		out.println("<head>");
		out.println("<title>Kalkulator serwletowy</title>");
		out.println("<link rel='stylesheet' type='text/css' href='styl.css'>");
		out.println("</head>");
		out.println("<body>");
		out.println("<h1>Kalkulator 3</h1>");
		out.println("<p>Wpisz liczby i wybierz działanie:</p>");		
		out.println("<form method='post'>");
		out.println("<input name='liczba1' type='number'>");
		out.println("<select name='operacja'>");
		out.println("<option value='+'>+</option>");
		out.println("<option value='-'>-</option>");
		out.println("<option value='*'>*</option>");
		out.println("<option value='/'>/</option>");
		out.println("</select>");		
		out.println("<input name='liczba2' type='number'>");
		out.println("<button>=</button>");
		out.println("</form>");
		
		String param1 = request.getParameter("liczba1");
		String param2 = request.getParameter("liczba2");
		String operacja = request.getParameter("operacja");
		
		try {
			long liczba1 = Long.parseLong(param1);
			long liczba2 = Long.parseLong(param2);
			long wynik = switch(operacja) {
				case "+" -> liczba1 + liczba2;
				case "-" -> liczba1 - liczba2;
				case "*" -> liczba1 * liczba2;
				case "/" -> liczba1 / liczba2;
				default -> throw new IllegalArgumentException("Nieznane działanie: " + operacja);
			};
			out.printf("<div class='wynik'>%d %s %d = <strong>%d</strong></div>\n",
					liczba1, operacja, liczba2, wynik);
		} catch (NumberFormatException e) {
			out.printf("<div class='error'>Niepoprawny format liczby</div>\n");
		} catch(Exception e) {
			out.printf("<div class='error'>Błąd: %s</div>\n", e.getMessage());				
		}
		out.println("</body>");
		out.println("</html>");
	}

}
