package zajecia.postgresql;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JOptionPane;

/* W tej wersji program korzysta z bazy danych "w transakcji", co oznacza,
 * że dopóki nie zatwierdzi zmian (commit), zmiany te nie są widoczne dla innych klientów,
 * nie są zapisane w sposób trwały, można je wycofać.
 */
public class Podwyzka3 {

	public static void main(String[] args) {
		final String url = "jdbc:postgresql://localhost/hr";
		
		try(Connection c = DriverManager.getConnection(url, "kurs", "abc123")) {
			// wyłączam tryb auto-commit, wchodzę w tryb transakcji
			c.setAutoCommit(false);
			
			List<String> jobs = znajdzJoby(c);
			String job = (String) JOptionPane.showInputDialog(null,
					"Wybierz job", "Komu dać podwyżkę?", JOptionPane.QUESTION_MESSAGE, null, jobs.toArray(), null);

			double avg1 = sredniaPensja(c, job);
			JOptionPane.showMessageDialog(null, "Średnia pensja na stanowisku " + job + " wynosi teraz " + avg1);
			
			BigDecimal zmiana = new BigDecimal(JOptionPane.showInputDialog("Podaj kwotę podwyżki"));
			
			zmienPensje(c, job, zmiana);

			double avg2 = sredniaPensja(c, job);
			JOptionPane.showMessageDialog(null, "Średnia pensja na stanowisku " + job + " wynosi teraz " + avg2);
			
			int wybor = JOptionPane.showConfirmDialog(null, "Czy zatwierdzić zmiany?");
			switch(wybor) {
			case JOptionPane.YES_OPTION:
				c.commit();
				break;
			case JOptionPane.NO_OPTION:
				c.rollback();
				break;
			default:
				// pass
			}
			
			double avg3 = sredniaPensja(c, job);
			JOptionPane.showMessageDialog(null, "Średnia pensja na stanowisku " + job + " wynosi teraz " + avg3);
			
			JOptionPane.showMessageDialog(null, "Koniec programu, zaraz sie rozłączę...");
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}
	
	private static double sredniaPensja(Connection c, String job) throws SQLException {
		String sql = "SELECT avg(salary) FROM employees WHERE job_id = ?";
		try (PreparedStatement stmt = c.prepareStatement(sql)) {
			stmt.setString(1, job);
			try (ResultSet rs = stmt.executeQuery()) {
				if (rs.next()) {
					return rs.getDouble(1);
				}
			}
		}
		return 0.0;
	}

	private static List<String> znajdzJoby(Connection c) throws SQLException {
		List<String> jobs = new ArrayList<>();
		try(PreparedStatement stmt = c.prepareStatement("SELECT DISTINCT job_id FROM employees ORDER BY 1");
			ResultSet rs = stmt.executeQuery()) {
			while(rs.next()) {
				jobs.add(rs.getString(1));
			}
		}
		return jobs;
	}
	
	private static void zmienPensje(Connection c, String job, BigDecimal zmiana) throws SQLException {
		final String sql = "UPDATE employees SET salary = salary + ? WHERE job_id = ?";
		try(PreparedStatement stmt = c.prepareStatement(sql)) {
			stmt.setBigDecimal(1, zmiana);
			stmt.setString(2, job);
			int ile = stmt.executeUpdate();
			JOptionPane.showMessageDialog(null, "UPDATE wykonany. Zmieniono " + ile + " rekordów.");
		}
	}
}
