package zajecia.postgresql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.swing.JOptionPane;

public class Podwyzka2 {

	public static void main(String[] args) {
		try(Connection c = DriverManager.getConnection("jdbc:postgresql://localhost/hr", "kurs", "abc123")) {
			
			// Aby zacząć pracować w trybie transakcji, należy przełączyć opcję autoCommit na false.
			// Inaczej mówiąc, zmiany trzeba będzie jawnie zatwierdzać poleceniem commit.
			c.setAutoCommit(false);
			
			String job = JOptionPane.showInputDialog("Podaj kod stanowiska");
			try(PreparedStatement stmt = c.prepareStatement("SELECT avg(salary) FROM employees WHERE job_id = ?")) {
				stmt.setString(1, job);
				try(ResultSet rs = stmt.executeQuery()) {
					if(rs.next()) {
						double srednia = rs.getDouble(1);
						JOptionPane.showMessageDialog(null, "Średnia pensja: " + srednia);
					}
				}
			}
			
			int zmiana = Integer.parseInt(JOptionPane.showInputDialog("Podaj zmianę pensji:"));
			
			try(PreparedStatement stmt = c.prepareStatement("UPDATE employees SET salary = salary + ? WHERE job_id = ?")) {
				stmt.setInt(1, zmiana);
				stmt.setString(2, job);
				
				// Do wykonywania poleceń niebędących zapytaniami, np. INSERT, UPDATE, DELETE, ale też CREATE / ALTER TABLE,
				// używa się executeUpdate
				int ile = stmt.executeUpdate();
				JOptionPane.showMessageDialog(null, "Zmodyfikowano " + ile + " rekordów");
			}
			
			try(PreparedStatement stmt = c.prepareStatement("SELECT avg(salary) FROM employees WHERE job_id = ?")) {
				stmt.setString(1, job);
				try(ResultSet rs = stmt.executeQuery()) {
					if(rs.next()) {
						double srednia = rs.getDouble(1);
						JOptionPane.showMessageDialog(null, "Średnia pensja: " + srednia);
					}
				}
			}
			
			int wybor = JOptionPane.showConfirmDialog(null, "Czy zatwierdzić zmiany?");
			switch(wybor) {
				case JOptionPane.YES_OPTION -> c.commit();
				case JOptionPane.NO_OPTION -> c.rollback();
				case JOptionPane.CANCEL_OPTION -> {/* nic */}
			}
			
			try(PreparedStatement stmt = c.prepareStatement("SELECT avg(salary) FROM employees WHERE job_id = ?")) {
				stmt.setString(1, job);
				try(ResultSet rs = stmt.executeQuery()) {
					if(rs.next()) {
						double srednia = rs.getDouble(1);
						JOptionPane.showMessageDialog(null, "Średnia pensja: " + srednia);
					}
				}
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

}
