package zajecia.postgresql;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Odczyt2 {

	// W tej wersji:
	// - stosujemy try-with-resources, aby prawidłowo zamknąć połączenie i pozostałe zasoby
	// - zamiast Statement używamy PreparedStatement - wersja, w której zapytanie SQL podaje się wcześniej,
	//   w prepareStatement, a nie dopiero w executeQuery
	//   Jeden obiekt prepareStatement może być używany wielokrotnie; można przekazywać parametry, o czym później.
	// - Podajemy nazwy kolumn, a nie numery.
	public static void main(String[] args) {
		try(Connection c = DriverManager.getConnection("jdbc:postgresql://localhost:5432/hr", "kurs", "abc123");
			PreparedStatement stmt = c.prepareStatement("SELECT * FROM employees ORDER BY employee_id");
			ResultSet rs = stmt.executeQuery()) {
			
			while(rs.next()) {
				int id = rs.getInt("employee_id");
				String firstName = rs.getString("first_name");
				String lastName = rs.getString("last_name");
				String jobId = rs.getString("job_id");
				BigDecimal salary = rs.getBigDecimal("salary");
				System.out.println("Pracownik nr " + id + ": " + firstName + " " + lastName + " (" + jobId + ") zarabia " + salary);
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

}
