package pracownicy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Używamy operacji dodanych w Java 8 : putIfAbsent i computeIfPresent

public class Grupowanie4 {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("pracownicy.csv");
		
		Map<String, Integer> sumy = new HashMap<>();
		Map<String, Integer> ilosci= new HashMap<>();
		
		for (Employee emp : emps) {
			// w razie gdyby wartości jeszcze nie było, wstaw 0
			sumy.putIfAbsent(emp.getJobTitle(), 0);
			ilosci.putIfAbsent(emp.getJobTitle(), 0);
			
			// zakładając, że wartość już jest, zwiększ - robimy to "funkcyjnie"
			// funkcja przyjmuje dwa parametry: klucz i starą wartość
			// a na ich podstawie ma zwrócić nową wartość do umieszczenia w słowniku
			sumy.computeIfPresent(emp.getJobTitle(), 
					(klucz, dotychczasowaSuma) -> dotychczasowaSuma + emp.getSalary());

			ilosci.computeIfPresent(emp.getJobTitle(), 
					(klucz, dotychczasowaIlosc) -> dotychczasowaIlosc + 1);
		}
		
		for(String job : sumy.keySet()) {
			int suma = sumy.get(job);
			int ilosc = ilosci.get(job);
			double srednia = 1.0 * suma / ilosc;
			System.out.printf("|%32s | %2d | %8.2f |\n", job, ilosc, srednia);
		}
	}

}
