package alx.p13_enkapsulacja.v4_po_zmianie;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.DoubleStream;

public class Student extends Osoba {
	private String kierunek;
	private int rok;
	
	// Ukrywamy szczegóły implementacji - klient nie musi wiedzieć, w jaki sposób przechowujemy oceny studenta ("to nasza prywatna sprawa")
	// Żadna inna klasa nie może odwoływać się bezpośrednio do tej tablicy.
	private List<Double> oceny = new ArrayList<>();

	public Student() {
		
	}
	
	public Student(String imie, String nazwisko, LocalDate dataUrodzenia, String kierunek, int rok) {
		super(imie, nazwisko, dataUrodzenia);
		this.kierunek = kierunek;
		this.rok = rok;
	}
	
	public String getKierunek() {
		return kierunek;
	}

	public void setKierunek(String kierunek) {
		this.kierunek = kierunek;
	}

	public int getRok() {
		return rok;
	}

	public void setRok(int rok) {
		this.rok = rok;
	}

	public void dodajOcene(double ocena) {
		oceny.add(ocena);
	}

	public double sredniaOcen() {
		return oceny.stream().mapToDouble(x->x).average().orElse(0.0);
	}

	public void przedstawSie() {
		System.out.println("Hej tu " + getImie() + " " + getNazwisko() + ", jestem studentem " + rok + " roku kierunku " + kierunek);
	}
	
}
