package alx.p06_funkcje.przyklady;

import java.util.Random;

public class FunkcjeZWarunkami {
	// Funkcje, które zwracają wyniki za pomocą return, mogą posiadać bardziej złożoną treść,
	// np. używać if-ów, switch-ów, pętli...
	// return nie musi być wtedy ostatnią instrukcją, może występować w kilku miejscach,
	// a kompilator będzie sprawdzał "czy w każdej sytuacji na pewno funkcja zwróci jakiś wynik"
	
	static int wieksza(int x, int y) {
		if(x > y) {
			return x;
		} else {
			return y;
		}
	}
	
	// jeszcze bardziej zwięzła wersja, z wykorzystaniem wyrażenia warunkowego ?:
	static int wieksza_v2(int x, int y) {
		return x > y ? x : y;
	}

	public static void main(String[] args) {
		Random random = new Random();
		int x = random.nextInt(10);
		int y = random.nextInt(10);
		
		System.out.println(" x = " + x);
		System.out.println(" y = " + y);
		
		int wieksza = wieksza(x, y);
		System.out.println("większą z nich jest: " + wieksza);
	}

}
