package watki.na_zajeciach;

public class Konto {
	private final int numer;
	private String wlasciciel;
	private int saldo;
	
	public Konto(int numer, String wlasciciel, int saldo) {
		this.numer = numer;
		this.wlasciciel = wlasciciel;
		this.saldo = saldo;
	}

	public String getWlasciciel() {
		return wlasciciel;
	}

	public void setWlasciciel(String wlasciciel) {
		this.wlasciciel = wlasciciel;
	}

	public int getNumer() {
		return numer;
	}

	public synchronized int getSaldo() {
		return saldo;
	}

	@Override
	public String toString() {
		return "Konto nr " + numer + ", wł. " + wlasciciel + ", saldo: " + saldo;
	}

	// Gdy metoda jest synchronizowana, to zapobiega jednoczesnemu wykonywaniu jej treści przez równe wątki.
	// Dokładnie: Gdy jeden wątek wykonuje JAKĄKOLWIEK metodę synchronizowaną na danym obiekcie,
	// to żaden INNY wątek nie może rozpocząć wykonywania JAKIEJKOLWIEK metody synchronizowanej NA TYM SAMYM OBIEKCIE.
	// Wątek, który próbuje wejść do takiej metody, zostanie wstrzymany i wpuszczony dopiero, gdy obiekt będzie wolny.
	public synchronized void wplata(int kwota) {
		if(kwota <= 0) {
			throw new IllegalArgumentException("Ujemna kwota w wplata");
		}
		saldo += kwota;
		notify();
	}

	public synchronized void wyplata(int kwota) throws BrakSrodkow {
		if(kwota <= 0) {
			throw new IllegalArgumentException("Ujemna kwota w wyplata");
		}
		if(kwota > saldo) {
			throw new BrakSrodkow("Brak środków na koncie nr " + numer
					+". Żądano " + kwota + ", a jest " + saldo + ".");
		}
		saldo -= kwota;
	}

	public synchronized void wyplataCzekaj(int kwota) throws BrakSrodkow {
		if(kwota <= 0) {
			throw new IllegalArgumentException("Ujemna kwota w wyplata");
		}
		try {
			while(kwota > saldo) {
				wait();
			}
			saldo -= kwota;
			notify();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}
}
