package emps.strumieniowo;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;

import javax.swing.JOptionPane;

public class P5_MinMax_v4 {
	// W tej wersji użytkownik podaje nazwę miasta, a program znajduje pracownika, który zarabia nawięcej w tym mieście.
	
	public static void main(String[] args) {
		String city = JOptionPane.showInputDialog("Podaj nawę miasta");
		
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		// Zamiast po uzyskaniu obiektu Optional za pomocą ifa sprawdzać czy wynik został uzyskany,
		// możemy "w locie" zmapować wynik typu Employee na String
		// i w jednym wyrażeniu uzyskać Stringa opisującego sytuację gdy dane są, lub gdy danych nie ma.
		
		// map na obiekcie Optional działa tak:
		// - jeśli w pudełku coś jest, to zmapuj zawartość pudełka (np. z Optional<Employee> powstaje Optional<String>)
		// - jeśli pudełko jest puste, to pozostaje puste
		
		String tekst = emps.stream()
				.filter(emp -> Objects.equals(emp.getCity(), city))
				.max(Comparator.comparingInt(Employee::getSalary))
				.map(emp -> "W mieście " + city + " najbogatszy jest " + emp.getFirstName() + " " + emp.getLastName() + " z pensją " + emp.getSalary())
				.orElse("Nikt nie pracuje w mieście " + city);
		
		JOptionPane.showMessageDialog(null, tekst);
	}

	// Zarówno strumienie, jak i obiekty Optional, to są "monady".
	// Tę teorie znają programiści języka Haskell :-)
}
