package emps.obiektowo;

import java.util.List;

// Program wypsiuje pracowników w kolejności posortowanej zwn pensje.

public class P7b_Sortowanie {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		// W tej wersji Comparator zdefiniujemy za pomocą wyrażenia lambda.
		// Zalecane jest porównywanie liczb za pomocą gotowych metod compare,
		// gdyż zapobiega to problemom z overflowami.
		emps.sort((emp1, emp2) -> Integer.compare(emp1.getSalary(), emp2.getSalary()));
		
		for(Employee emp : emps) {
			System.out.println(emp);
		}
	}

}
