package emps.obiektowo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Grupowanie5 {
    // działanie merge na przykładzie sumy:
    // zaglądamy pod klucz emp.getJobTitle():
    // - jeśli tam jeszcze nic nie ma → wstawiana jest wartość getSalary()
    // - jeśli już coś było, to do starej wartości dodawane jest getSalary
    //   za pomocą funkcji podanej w trzecim argumencie.
	//   Tutaj jest to funkcja sum (dodawanie), a więc liczby matematycznie sumowane.
	
	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		Map<String, Integer> sumy = new HashMap<>();
		Map<String, Integer> ilosci = new HashMap<>();
		
		for(Employee emp : emps) {
			sumy.merge(emp.getJobTitle(), emp.getSalary(), Integer::sum);
			ilosci.merge(emp.getJobTitle(), 1, Integer::sum);
		}
		
		for(String job : sumy.keySet()) {
			int suma = sumy.get(job);
			int ile = ilosci.get(job);
			double srednia = (double)suma / ile;
			System.out.printf("| %-32s | %2d | %8.2f |\n", job, ile, srednia);
		}
	}
}
