package com.example.demo.data;

import java.util.List;
import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import com.example.demo.model.Employee;

@Controller
@RequestMapping("/emps4")
public class Controller4 {
	@Autowired
	private Repository4 repository;

	@GetMapping
	public String showAll(Model model) {
		List<Employee> emps = repository.findAll();
		model.addAttribute("emps", emps);
		return "employees.html";
	}

	@GetMapping("/{id}")
	public String showOne(Model model, 
			@PathVariable("id") Integer employeeId) {

		Optional<Employee> emp = repository.findById(employeeId);
		List<Employee> emps;
		if (emp.isPresent()) {
			emps = List.of(emp.get());
		} else {
			emps = List.of();
		}
		model.addAttribute("emps", emps);
		return "employees.html";
	}

}
