<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Katalog towarów</title>
<link rel="stylesheet" type="text/css" href="/styl.css"/>
</head>
<body>
<h1>Wszystkie produkty</h1>

<c:forEach var="product" items="${products}">
	<div class="product">
		<p>Towar <a href="products/${product.productId}" class="product-name">${product.productName}</a></p>
		<p>Cena: <span class="product-price">${product.price}</span></p>
		<p class="product-description">${product.description}</p>
	    <div class="action"><a href="/products/${product.productId}/edit">Edytuj</a></div>
    </div>
</c:forEach>

<div><a href="/products/new">Dodaj nowy produkt</a></div>
<div><a href="/">Wróć na stronę główną</a></div>

</body>
</html>
