package com.example.demo;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping("/kalkulator")
public class Kalkulator {
	// @Autowired powoduje, że Spring sam wpisze tutaj referencję do obiektu (do "komponentu" / "beana" zarejestrowanego w tej aplikacji)
	// Nawet, gdy zmienna jest typu interfejs, a istnieje komponent, który implementuje ten interfejs,
	// to Spring znajdzie ten komponent i go użyje.
	@Autowired
	private LogikaKalkulatora logikaKalkulatora;

	@GetMapping
	public String kalkulatorGet() {
		return "kalkulator.html";
	}
	
	// Spring automatycznie przekaże parametry zapytania (dane z formularza)
	// do tej metody - wystarczy zadeklarować parametry o tej samej nazwie.
	@PostMapping
	public String kalkulatorPost(Model model, Long liczba1, Long liczba2, String operacja) {
		long wynik = getLogikaKalkulatora().oblicz(operacja, liczba1, liczba2);
		model.addAttribute("wynik", wynik);
		return "kalkulator.html";
	}

	// Ta metoda zadziała, gdy ktoś wejdzie pod adres /kalkulator/historia
	@GetMapping("/historia")
	public String pokazHistorie(Model model) {
		model.addAttribute("historia", getLogikaKalkulatora().getHistoriaDzialan());
		return "historia.html";
	}

	public LogikaKalkulatora getLogikaKalkulatora() {
		return logikaKalkulatora;
	}

}
