<%@page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@page import="java.time.LocalTime"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Przykład JSP</title>
</head>
<body>
<h1>Przykład JSP</h1>
<h2>Zwykły HTML</h2>
<p>Zasadniczo, można tutaj pisać jak w zwykłym HTML-u...</p>
<!-- To jest komentarz HTML, który trafi do klienta. -->
<%-- To jest komentarz JSP - on nie trafi do klienta w żadnej formie. --%>

<h2>Skryptlety</h2>
<p>Czyli fragmenty kodu Java</p>
<%-- W JSP można umieszczać fragmenty kodu Java - to się nazywa "scriptlet".
	Te instrukcje wykonają się po stronie serwera. Np. mogą skorzystać z bazy danych itp.
	To działa inaczej niż JavaScript, który wykonuje się w przeglądarce.
--%>

<%
System.out.println("To wypisało JSP..."); // na konsolę
out.println("a kuku"); // na stronie, w odp. do klienta
// out to jest przykład "implicit object", czyli zmiennej, która jest już zadeklarowana i której używać w kodzie
// To jest TEN PrintWriter, którego używaliśmy w serwletach pisząc PrintWriter out = response.getWriter();

int x = 15;
x++;
%>

<p>Z powrotem HTML</p>
<p>Tak można wypisać wartość: <%=x %></p>
<p>Godzina <%=LocalTime.now()%></p>

<%-- Deklaracja na poziomie klasy. Można np. zadeklarować zmienna statyczną ("globalną"). --%>
<%! static int licznik = 0; %>

<p>Licznik: <%= ++licznik %></p>

<h2>Expression Language</h2>
<%--
Bezpośrednie wstawianie kodu Javy jest "brzydkie".
W JSP technikami bardziej zalecanymi są wyrażenia "EL" ("Expression Language")
oraz biblioteki tagów (taglibs) w połaczeniu z dostępem do obiektów "bean" przygotowanych przez aplikację.
--%>

<p>Wynik działania: ${2*3+4}</p>
<p>Parametr imie: ${param.imie}</p>
<p>Wynik liczba1+liczba2: <strong>${param.liczba1 + param.liczba2}</strong></p>

<h2>Taglibs - biblioteki tagów</h2>
<ol>
<c:forEach var="imie" items="Ala,Ola,Ela,Ula">
<li>${imie}</li>
</c:forEach>
</ol>

<h2>Odwołania do beanów</h2>
<jsp:useBean id="ala" class="beans.Osoba"/>
<p>ala: ${ala}</p>

<%-- setProperty wywołuje na obiekcie odp. setter --%>
<jsp:setProperty name="ala" property="imie" value="Ala"/>
<jsp:setProperty name="ala" property="nazwisko" value="Kowalska"/>
<jsp:setProperty name="ala" property="wiek" value="30"/>
<p>ala: ${ala}</p>
<%-- Pisząc obiekt.własność tak naprawdę wywołujemy obiekt.getWłasność() --%>
<p>pola obiektu ala: ${ala.imie}, ${ala.nazwisko}, opis: ${ala.opis}</p>


<jsp:useBean id="obiekt" class="beans.InfoBean" scope="session"/>
<p>Mam beana: ${obiekt}</p>
<p>Tekst: ${obiekt.tekst}</p>
<%-- Tak naprawdę wywoływane jest obiekt.getTekst() --%>

<%-- A teraz obiekt.setTekst("Ola ma psa nr 5") --%>
<jsp:setProperty name="obiekt" property="tekst" value="Ola ma psa nr ${10 + obiekt.licznik}"/>
<p>Tekst po zmianie: ${obiekt.tekst}</p>

<p>upper: ${obiekt.tekstDuze}</p>
<p>czas: ${obiekt.currentTime}</p>
<p>pola daty i czasu: ${obiekt.currentTime.hour}:${obiekt.currentTime.minute} , dzień roku: ${obiekt.currentTime.dayOfYear}</p>
<p>licznik: ${obiekt.licznik}</p>
</body>
</html>
