package rozwiazania_zadan.r2.z1.p4_pierwsze;

import java.util.Scanner;

public class LiczbyPierwsze2 {
	// Ta wersja sprawdza czy liczba jest podzielna przez jakąkolwiek liczbę inną niż 1 i ona sama.
	// Gdyby tak było, to nie jest pierwsza.
	// Również "1" nie jest l.pierwszą.
	// Gdy liczba nie jest pierwsza, to pętla jest przerywana szybiej (niż v1). spr np. 2147483648
	// Jeśli jest pierwsza, to pętla musi dojść do końca, spr. np. 2147483647
	static boolean czyPierwsza(long liczba) {
		if(liczba == 1) {
			return false;
		}
		
		for(long i = 2; i < liczba; i++) {
			if(liczba % i == 0) {
				return false; // skoro dzieli się przez jakąś liczbę pośrednią (nie 1 i nią samą), to nie jest pierwsza
			}
		}
		return true;
	}

	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);
		System.out.println("Aby zakończyć, wpisz 0");
		while(true) {
			System.out.print("Podaj liczbę: ");
			long liczba = sc.nextLong();
			if(liczba == 0) break;
			
			// pomiar czasu
			long p = System.currentTimeMillis();
			boolean wynik = czyPierwsza(liczba);
			long k = System.currentTimeMillis();
			
			if(wynik) {
				System.out.println("Liczba " + liczba + " jest pierwsza");
			} else {
				System.out.println("Liczba " + liczba + " nie jest pierwsza");
			}
			System.out.println("Sprawdzenie trwało " + (k-p) + " ms");
			System.out.println();
		}

	}

}
