package watki.na_zajeciach;

public class ABC_PierwszeWatki {

	public static void main(String[] args) {
		System.out.println("Początek main");
		
		// Obiekt typu Runnable określa, co ma robić wątek.
		// Jest to zapisane w metodzie run tego obiektu.
		Runnable przepis = new Runnable() {
			public void run() {
				System.out.println("AAA start");
				for(int i = 1; i <= 1000; i++) {
					System.out.println("AAA " + i);
				}
				System.out.println("AAA koniec");
			}
		};
		
		// Sam wątek jest umieszczony w obiekcie typu Thread i najczęściej tworzy się go w oparciu o Runnable.
		Thread watekA = new Thread(przepis);
		
		// Bardzo często obiekt Runable twozy się jako tzw. "klasę anonimową":
		Thread watekB = new Thread(new Runnable() {
			public void run() {
				System.out.println("BBB start");
				for(int i = 1; i <= 1000; i++) {
					System.out.println("BBB " + i);
				}
				System.out.println("BBB koniec");
			}
		});
		
		// Ale od Java 8 można te użyć wyrażenia lambda.
		Thread watekC = new Thread(() -> {
			System.out.println("CCC start");
			for(int i = 1; i <= 1000; i++) {
				System.out.println("CCC " + i);
			}
			System.out.println("CCC koniec");
		});
		
		System.out.println("Uruchamiam wątki");
		
		watekA.start();
		watekB.start();
		watekC.start();
		
		System.out.println("Koniec main");
	}

}
