package emps.strumieniowo;

import java.util.Comparator;
import java.util.List;

public class P7_Sortowanie {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		emps.stream()
				.sorted(Comparator.comparingInt(Employee::getSalary).reversed())
				.map(emp -> emp.getFirstName() + " " + emp.getLastName() + " " + emp.getSalary())
				.forEachOrdered(System.out::println);
		
		// Gdy zależy nam na określonej kolejności wypisania obiektów,
		// to lepiej użyć forEachOrdered zamiast forEach.
		// W praktyce będzie to miało znaczenie tylko w przypadku strumieni równoległych (paraller),
		// ale najlepiej od razu użyć właściwej operacji, aby późniejsze zmiany nie zepsuły działania.
	}

}
