package emps.strumieniowo;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Grupowanie2 {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		// Drugi parametr kolektora groupingBy określa "co zrobić z każdą grupą" i też ma być kolektorem.
		// W tym przypadku dla każdej grupy pracowników obliczamy średnią pensję.
		Map<String, Double> srednie = emps.stream()
				.collect(Collectors.groupingBy(Employee::getJobTitle,
						Collectors.averagingInt(Employee::getSalary)));
		
		srednie.forEach((job, avg) -> System.out.printf("%32s → %8.2f\n", job, avg));
	}

}
