"""
URL configuration for webowy project.

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/5.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""

from django.contrib import admin
from django.urls import path

# dwa style importowania do wyboru:
from aplikacja.views import *
import sklep.views

urlpatterns = [
    path("admin/", admin.site.urls),
    path("", root),
    path("hello", hello),
    path("czas1", daj_czas),
    path("czas2", czas_html),
    path("czas3", czas_szablon),
    path("rozmowa", rozmowa),
    path("kalkulator", kalkulator),
    path("kalkulator_post", kalkulator_post),
    path("formularz", formularz),
    path("sklep", sklep.views.lista_produktow),
    path("sklep.txt", sklep.views.lista_produktow_txt),
    path("sklep.html", sklep.views.lista_produktow_html)
]
