from django.http import HttpRequest, HttpResponse
from django.shortcuts import render

from datetime import datetime

# Create your views here.

def root(request):
    return render(request, 'index.html')

def hello(request):
    return HttpResponse('Hello <b style="color:blue">Django</b>!')

def daj_czas(request):
    return HttpResponse(datetime.now())

def czas_html(request):
    godzina = datetime.now().strftime('%H:%M:%S')
    html = f'''<!DOCTYPE html>
    <html><head>
    <title>Która godzina</title>
    </head>
    <body style="background-color: #FFFFDD">
    <p>Teraz jest późna godzina <strong style="color:purple">{godzina}</strong></p>
    </body>
    </html>
    '''
    return HttpResponse(html, content_type='text/html;charset=UTF-8')

def czas_szablon(request):
    return render(request, 'szablon_czasu.html', {'now': datetime.now()})

def rozmowa(request: HttpRequest) -> HttpResponse:
    # to jest słownik i można odczytać wartość z klucza za pomocą []
    # ale w razie braku parametru o tej nazwie będzie KeyError
    # imie = request.GET['imie']

    # gdy użyjemy meody get, możmy uniknąć błędu i podstawić domyślną wartość
    imie = request.GET.get('imie', '')
    powitanie = f'Witaj {imie}!' if imie else 'Witaj nieznana osobo...'
    return render(request, 'rozmowa.html', context={'powitanie': powitanie})

