from django.http import HttpRequest, HttpResponse
from django.shortcuts import render

from datetime import datetime

# Create your views here.

def root(request):
    return render(request, 'index.html')

def hello(request):
    return HttpResponse('Hello <b style="color:blue">Django</b>!')

def daj_czas(request):
    return HttpResponse(datetime.now())

def czas_html(request):
    godzina = datetime.now().strftime('%H:%M:%S')
    html = f'''<!DOCTYPE html>
    <html><head>
    <title>Która godzina</title>
    </head>
    <body style="background-color: #FFFFDD">
    <p>Teraz jest późna godzina <strong style="color:purple">{godzina}</strong></p>
    </body>
    </html>
    '''
    return HttpResponse(html, content_type='text/html;charset=UTF-8')

def czas_szablon(request):
    return render(request, 'szablon_czasu.html', {'now': datetime.now()})

def rozmowa(request: HttpRequest) -> HttpResponse:
    # to jest słownik i można odczytać wartość z klucza za pomocą []
    # ale w razie braku parametru o tej nazwie będzie KeyError
    # imie = request.GET['imie']

    # gdy użyjemy meody get, możmy uniknąć błędu i podstawić domyślną wartość
    imie = request.GET.get('imie', '')
    powitanie = f'Witaj {imie}!' if imie else 'Witaj nieznana osobo...'
    return render(request, 'rozmowa.html', context={'powitanie': powitanie})

def kalkulator(request:HttpRequest) -> HttpResponse:
    try:
        arg1 = int(request.GET.get('arg1', '0'))
        arg2 = int(request.GET.get('arg2', '0'))
        operacja = request.GET.get('operacja', '')
        match operacja:
            case '+': wynik = arg1 + arg2
            case '-': wynik = arg1 - arg2
            case '*': wynik = arg1 * arg2
            case '/': wynik = arg1 / arg2
            case '%': wynik = arg1 % arg2
            case '^': wynik = arg1 ** arg2
            case  _ : wynik = 0
    except Exception as e:
        wynik = f'jakiś błąd {e}'
    return render(request, 'kalkulator.html',
                  context={'wynik': wynik})


dzialania = {
    'add': ('+', lambda x,y: x + y),
    'sub': ('-', lambda x,y: x - y),
    'mul': ('×', lambda x,y: x * y),
    'div': ('÷', lambda x,y: x // y),
    'mod': ('mod', lambda x,y: x % y),
    'pow': ('^', lambda x,y: x ** y),
}

def kalkulator_post(request: HttpRequest) -> HttpResponse:
    # W obiekcie request zapisane są wszelkie dane, który przyszły w zapytaniu,
    # w tym parametry zapytania. Aby wygodniej nam się z tego korzystało, do nagłówka funkcji dopisujemy type hints.

    # Ten słownik zawiera wszystkie informacje przekazane do szablonu.
    # W tej wersji buduję go stopniowo, w zależności od tego, co dzieje się w funkcji
    kontekst = {}

    # Jeśli zapytanie zawiera dane z formularza, to wyliczamy wynik.
    if 'operacja' in request.POST and 'liczba1' in request.POST and 'liczba2' in request.POST:
        try:
            liczba1 = int(request.POST['liczba1'])
            liczba2 = int(request.POST['liczba2'])
            op = request.POST['operacja']
            znak, funkcja = dzialania[op]
            kontekst['wynik'] = funkcja(liczba1, liczba2)
            kontekst['znak'] = znak
        except KeyError as e:
            kontekst['error'] = 'nieznane działanie'
        except Exception as e:
            kontekst['error'] = str(e)

    return render(request=request,
                  template_name='kalkulator_post.html',
                  context=kontekst)


def formularz(request):
    return render(request, 'formularz.html')


