package sklep.rest.ext;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import sklep.db.RecordNotFound;

@Provider
public class RecordNotFoundMapper implements ExceptionMapper<RecordNotFound> {

    @Override
    public Response toResponse(RecordNotFound exception) {
        String html = "<html><body><h1>Nie znaleziono</h1><p style='color:red'>"
                + exception.getMessage() + "</p></body></html>";
        
        return Response.status(404)
                .type("text/html")
                .entity(html)
                .build();
    }

}
