package rest;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;

@Path("/dt")
@Produces("text/plain;charset=UTF-8")
// @Singleton
public class TimeResource {
    // W JAX-RS domyślne zachowanie jest takie, że dla każdego requestu tworzony jest nowy obiekt klasy obsługującej zapytania.
    // (polityka "per request"; można ją zmienić za pomocą adnotacji @Singleton - wtedy jeden obiekt obsłuży wszystkie zapytania)
    // Daje to możliwość zapisania pewnych ulotnych informacji w polach prywatnych tej klasy - nikt nam ich nie nadpisze.

    private LocalDateTime dt = LocalDateTime.now();
    {
        System.out.println("Powstaje obiekt TimeResource z odczytanym czasem " + dt);
    }

    // ta metoda obsługuje adres .../dt
    @GET
    public LocalDateTime odczytajDataICzas() {
        return dt;
    }

    // ta metoda obsługuje adres .../dt/date
    @GET
    @Path("/date")
    public LocalDate odczytajDate() {
        return dt.toLocalDate();
    }

    // ta metoda obsługuje adres .../dt/date/year
    @GET
    @Path("/date/year")
    public int odczytajRok() {
        return dt.getYear();
    }

    // ta metoda obsługuje adres .../dt/date/month
    @GET
    @Path("/date/month")
    public int odczytajMiesiac() {
        return dt.getMonthValue();
    }

    // ta metoda obsługuje adres .../dt/date/day
    @GET
    @Path("/date/day")
    public int odczytajDzien() {
        return dt.getDayOfMonth();
    }

    // ta metoda obsługuje adres .../dt/time
    @GET
    @Path("/time")
    public LocalTime odczytajCzas() {
        return dt.toLocalTime();
    }

    // ta metoda obsługuje adres .../dt/time/hour
    @GET
    @Path("/time/hour")
    public int odczytajGodzine() {
        return dt.getHour();
    }

    // ta metoda obsługuje adres .../dt/time/minute
    @GET
    @Path("/time/minute")
    public int odczytajMinute() {
        return dt.getMinute();
    }

    // ta metoda obsługuje adres .../dt/time/second
    @GET
    @Path("/time/second")
    public int odczytajSekunde() {
        return dt.getSecond();
    }

}
