package rest;

import jakarta.ws.rs.*;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;

import java.time.LocalDateTime;
import java.util.Arrays;

@Path("/parametry")
@Produces("text/plain")
public class Parametry {
    @Path("/witaj")
    @GET
    // w Springu byłoby tak: @GetMapping(path="/witaj", produces="text/plain")
    public String witaj(@QueryParam("imie") String imie) {
        return "Witaj " + imie;
    }

    // .../parametry/query?a=Ala&b=Basia&t=Tomek&t=Tadeusz&t=Tola
    @GET
    @Path("/query")
    public String query(
            @QueryParam("a") @DefaultValue("Aga") String a,
            @QueryParam("b") String b,
            @QueryParam("t") String[] t) {

        return "Parametr a = " + a
                + "\nParametr b = " + b
                + "\nTablica: " + Arrays.toString(t);
    }

    // .../parametry/query;a=Ala;b=Basia;t=Tomek;t=Tadeusz;t=Tola
    @GET
    @Path("/matrix")
    public String matrix(
            @MatrixParam("a") @DefaultValue("Adam") String a,
            @MatrixParam("b") String b,
            @MatrixParam("t") String[] t) {

        return "Parametr a = " + a
                + "\nParametr b = " + b
                + "\nTablica: " + Arrays.toString(t);
    }

    // /parametry/path/Ala/123/98765qwerty
    // przykład realnego użycia: /products/{id}
    @GET
    @Path("/path/{a}/{b}/{cyfry:\\d+}{litery:[A-Za-z]*}")
    public String pathParam(
            @PathParam("a") String a,
            @PathParam("b") String b,
            @PathParam("cyfry") String cyfry,
            @PathParam("litery") String litery
    ) {

        return "Parametr a = " + a
                + "\nParametr b = " + b
                + "\nCyfry: " + cyfry
                + "\nLitery: " + litery;
    }

    @GET
    @Path("/headers")
    public String headers(
            @HeaderParam("accept") String accept,
            @HeaderParam("user-agent") String agent
    ) {
        return "Accept: " + accept
                + "\nUser-Agent: " + agent;
    }

    @GET
    @Path("/cookies")
    public String cookies(
            @CookieParam("ciacho") String ciacho,
            @CookieParam("JSESSIONID") String sessionId
    ) {
        return "Ciacho: " + ciacho
                + "\nSesja: " + sessionId;
    }

    @GET
    @Path("/ustaw")
    // ustawia ciacho
    public Response ustawCiacho() {
        String ciacho = LocalDateTime.now().toString();
        return Response.ok()
                .cookie(new NewCookie.Builder("ciacho").value(ciacho).build())
                .type("text/plain")
                .entity("Ustawiam ciacho na: " + ciacho)
                .build();
    }
}
