package sklep.klient;

import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

import jakarta.xml.ws.Response;
import sklep.generated.Product;
import sklep.generated.ReadProductsByPriceResponse;
import sklep.generated.Sklep;
import sklep.generated.SklepService;

public class Klient5_AsyncHandler {

    public static void main(String[] args) {
        BigDecimal min = BigDecimal.valueOf(2000);
        BigDecimal max = BigDecimal.valueOf(3000);

        System.out.println("Początek programu");
        SklepService service = new SklepService();
        Sklep sklep = service.getSklepPort();
        System.out.println("Klient gotowy do pracy");

        System.out.println("Wysyłam zapytanie");
        // jako ostatni parametr przekazujemy AsyncHandler określając, co zrobić po otrzymaniu wyniku
        // Od Javy 8 najłatwiej przekazać to w formie wyrażenia lambda
        // ten kod wykona się w innym wątku po zakończeniu zadania
        Future<?> future = sklep.readProductsByPriceAsync(min, max, response -> {
            try {
                List<Product> products = response.get().getProduct();
                for(Product product : products) {
                    System.out.println(product.getProductName() + " za " + product.getPrice());
                }
            } catch(InterruptedException e) {
                System.out.println("interrupted");
            } catch(ExecutionException e) {
                System.out.println("Błąd w wykonaniu: " + e);
            }
        });

        for(int i = 1; i <= 50; i++) {
            System.out.println("lalala, robię coś inngo");
        }
        System.out.println("teraz poczekam na koniec zlecenia");
        try {
            future.get();
        } catch(InterruptedException e) {
            e.printStackTrace();
        } catch(ExecutionException e) {
            e.printStackTrace();
        }
        System.out.println("Koniec main");
    }
}
