package sklep.klient;

import java.math.BigDecimal;
import java.util.List;

import jakarta.xml.ws.Response;
import sklep.generated.Product;
import sklep.generated.ReadProductsByPriceResponse;
import sklep.generated.Sklep;
import sklep.generated.SklepService;

public class Klient4_Async {

    public static void main(String[] args) {
        BigDecimal min = BigDecimal.valueOf(2000);
        BigDecimal max = BigDecimal.valueOf(3000);
        
        System.out.println("Początek programu");
        SklepService service = new SklepService();
        Sklep sklep = service.getSklepPort();
        System.out.println("Klient gotowy do pracy");

        try {
            System.out.println("Wysyłam zapytanie");
            Response<ReadProductsByPriceResponse> response = sklep.readProductsByPriceAsync(min, max);
            System.out.println("Wysłałem zapytanie i mam obiekt reponse: " + response);
            
            // strategia odpytywania:
            while(! response.isDone()) {
                System.out.println("czekam na wynik");
                Thread.sleep(10);
            }
            List<Product> products = response.get().getProduct();
            for(Product product : products) {
                System.out.println(product.getProductName() + " za " + product.getPrice());
            }
        } catch (Exception e) {
            System.out.println("Błąd: " + e);
        }
        System.out.println("Koniec programu");
    }
}
