<%@page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@page import="java.time.LocalTime"%>
<%@page import="java.util.concurrent.atomic.AtomicInteger"%>
<%@taglib prefix="c" uri="jakarta.tags.core" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <link rel="stylesheet" type="text/css" href="styl.css">
    <title>Przykład pliku JSP</title>
</head>
<body>
<h1>Przykład JSP</h1>
<p>To jest zwykły tekst</p>

<form>
    <label for="imie">Podaj imię:</label>
    <input type="text" name="imie" id="imie">
    <br>
    <button>Wyślij</button>
</form>

<h2>Skryptlety</h2>
<%-- Plik JSP jest na serwerze tłumaczony na klasę serwletu i kompilowany. --%>
<%-- to jest komentarz JSP - to nie zostanie wysłane do klienta --%>
<!-- to jest komentarz HTML - to ZOSTANIE wysłane do klienta -->

<%
    int x = 100;
    String[] imiona = {"Ala", "Ola", "Ela"};
    out.println("x przed zmianą = " + x + "<br>");
    x += 50;
    out.println("x po zmianie = " + x + "<br>");
%>
<p>Wartość zmiennej: <%= x %></p>
<p>Bieżący czas: <%= LocalTime.now() %></p>
<%-- brzydki styl, ale działa: --%>
<ul>
    <% for(String imie : imiona) { %>
    <li><%= imie%></li>
    <% } %>
</ul>

<%-- skryptlet typu deklaracja - ten kod jest umieszczany na poziomie klasy, a nie wewnątrz metod --%>
<%!
    private final AtomicInteger licznik = new AtomicInteger();

    String hello() {
        return "Hello hello";
    }
%>

<p>Wartość licznika <%= licznik.incrementAndGet() %>
<p>Wywołanie <%= hello() %>
<hr>

<h2>Expression Language</h2>
<p>Wynik działania EL: ${2+3*4}</p>
<p>Parametr imie za pomocą EL : ${param.imie}</p>
<p>Parametr imie za pomocą %= : <%= request.getParameter("imie") %></p>

<hr>
<h2>Beany</h2>
<jsp:useBean id="obiekt" class="serwlety.PrzykladowyBean"/>
<%-- To jest wywołanie toString: --%>
<p>Po utworzeniu obiekt jest taki: ${obiekt}</p>

<%-- To jest wywołanie gettera: --%>
<p>Kolejna wartość licznika: ${obiekt.value}</p>
<%-- Istnieją też tagi jsp dedykowane do odczytu i zapisu(!) własności.
Tak naprawdę są realizowane poprzez wywołania gettera i settera. --%>
<p>Kolejna za pomocą <code>getProperty</code>: <jsp:getProperty name="obiekt" property="value"/> </p>
<jsp:setProperty name="obiekt" property="text" value="Ala ma ${2+3} kotów"/>
<p>Tekst po ustawieniu: ${obiekt.text}</p>
<p>Cały obiekt: ${obiekt}</p>
<jsp:setProperty name="obiekt" property="text" param="imie"/>
<p>Tekst po ustawieniu z parametru: ${obiekt.text}</p>
<p>Cały obiekt: ${obiekt}</p>
<p>Bieżący czas: ${obiekt.currentTime}, sama sekunda ${obiekt.currentTime.second},
    dzień roku ${obiekt.currentTime.dayOfYear}</p>

<%-- Gdy wpisujemy odwołanie do obiektu, to jest on printowany za pomocą toString().
    Gdy wpiszemy coś, co wygląda na odczyt pola obiektu, to jest wywoływany getter zwracający to property,
    np. osoba.wiek powoduje wywołanie getWiek()
    Gdy wpiszemy coś z nawiasami na końcu, to jest to wywołanie metody.
    Polecenie setProperty skutkuje wywołaniem settera, np. setNapis(...)
--%>

<p>Metoda: ${obiekt.wypiszPowitanie()}</p>
<p>Metoda z parametrem stałym: ${obiekt.innePowitanie("Ula")}</p>
<p>Metoda z parametrem z zapytania: ${obiekt.innePowitanie(param.imie)}</p>
<p>Metoda void ${obiekt.reset()}</p>
<p>Obiekt na końcu ${obiekt}</p>
<hr>

<h2>Biblioteki tagów</h2>
<%-- Biblioteka tagów ("taglib") to jest zestaw poleceń zapisywanych w formie znaczników w obrębie JSP.
Te znaczniki zawsze są poprzedzane prefiksem, np. <c:if>....

Tagliby można definiować samodzielnie, ale w 98% przypadków używa się zestawu nazywanego JSTL
"Java Standard Tag Library" (ostatnio Java → Jakarta ;) )
--%>

<c:if test="${not empty(param.imie)}">
    <div style="border: solid green 3px; padding: 1em">
        Pozdrawiamy osobę o imieniu ${param.imie}
    </div>
</c:if>

<ul>
    <c:forEach var="i" items="5,10,15">
        <li>${i}
            <c:choose>
                <c:when test="${i % 2 == 0}">parzyste</c:when>
                <c:otherwise>nieparzyste</c:otherwise>
            </c:choose>
        </li>
    </c:forEach>
</ul>

<jsp:setProperty name="obiekt" property="text" value="Ala ma kota a Ola ma psa"/>
<p>Cały napis: ${obiekt.text}</p>
<p>Słowa napisu:</p>
<ol>
    <c:forEach var="word" items="${obiekt.words}">
        <li>${word}</li>
    </c:forEach>
</ol>

</body>
</html>
