package serwlety;

import java.io.IOException;
import java.io.PrintWriter;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

@WebServlet("/kalkulator")
public class Kalkulator extends HttpServlet  {
    private static final long serialVersionUID = 1L;

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        out.append("""
                <!DOCTYPE html>
                <html>
                <head>
                <title>Rozmowa z serwletem</title>
                <link rel="stylesheet" type="text/css" href="styl.css">
                </head>
                <body>
                <h1>Rozmowa z serwletem</h1>
                """);
        
        out.append("""
                <form class='kalkulator'>
                Podaj pierwszą liczbę: <input type='number' name='liczba1'><br>
                Podaj drugą liczbę: <input type='number' name='liczba2'><br>
                Podaj znak działania:
                <select name='operacja'>
                <option value='+'>+</option>
                <option value='-'>+</option>
                <option value='*'>×</option>
                <option value='/'>÷</option>
                </select><br>
                <button>Oblicz</button>
                </form>
                """);
        
        String operacja = request.getParameter("operacja");
        String liczba1 = request.getParameter("liczba1");
        String liczba2 = request.getParameter("liczba2");
        if(operacja != null && liczba1 != null && liczba2 != null) {
            try {
                long x = Long.parseLong(liczba1);
                long y = Long.parseLong(liczba2);
                long wynik = switch(operacja) {
                    case "+" -> x + y;
                    case "-" -> x - y;
                    case "*" -> x * y;
                    case "/" -> x / y;
                    case "%" -> x % y;
                    default  -> 0;
                };
                out.append("<div class='wynik'>Wynik: " + wynik + "</div>");
            } catch (Exception e) {
                out.append("<div class='error'>Błąd: " + e + "</div>");
            }
        }
        
        out.append("""
                </body>
                </html>
                """);
    }
    
}
