<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output method="html" encoding="UTF-8" version="5"/>

    <xsl:template match="/">
        <html>
            <head>
                <title>Przykładowy sklep</title>
                <xsl:call-template name="wstaw_css"/>
            </head>
            <body>
                <h1>Asortyment sklepu</h1>
                <xsl:apply-templates />
            </body>
        </html>
    </xsl:template>

    <xsl:template match="kategoria">
        <div class="kategoria" id="K{@id}">
            <xsl:apply-templates select="nazwa"/>
            <xsl:apply-templates select="opis"/>
            <ul>
                <xsl:for-each select="//towar[@id-kategorii = current()/@id]">
                    <xsl:sort select="nazwa"/>
                    <li><a href="#T{@id-towaru}"><xsl:value-of select="nazwa"/></a></li>
                </xsl:for-each>
            </ul>
        </div>
    </xsl:template>

    <xsl:template match="towar">
        <div class="towar" id="T{@id-towaru}">
            <xsl:apply-templates select="nazwa"/>
            <xsl:if test="@id-kategorii">
                <div>Kategoria: <a href="#K{@id-kategorii}"><xsl:value-of select="/sklep/kategoria[@id = current()/@id-kategorii]/nazwa"/></a></div>
            </xsl:if>
            <div>Cena netto: <xsl:value-of select="format-number(cena, '0.00')" /> zł</div>
            <div>Cena brutto: <xsl:value-of select="format-number(cena * (1 + vat div 100), '0.00')" /> zł</div>
            <div>Stawka VAT: <xsl:value-of select="vat"/>%</div>
            <xsl:apply-templates select="opis"/>
        </div>
    </xsl:template>

    <xsl:template match="nazwa">
        <h2>
            <xsl:apply-templates />
        </h2>
    </xsl:template>

    <xsl:template match="opis">
        <p class="opis">
            <xsl:apply-templates />
        </p>
    </xsl:template>

    <xsl:template match="em">
        <strong>
            <xsl:apply-templates />
        </strong>
    </xsl:template>

    <xsl:template match="rem">
        <span class="rem">
            <xsl:apply-templates />
        </span>
    </xsl:template>

    <xsl:template match="term">
        <dfn>
            <xsl:apply-templates />
        </dfn>
    </xsl:template>

    <xsl:template match="link">
        <a href="{@href}">
            <xsl:apply-templates />
        </a>
    </xsl:template>

    <xsl:template match="br">
        <br/>
    </xsl:template>

    <xsl:template name="wstaw_css">
        <style type="text/css"><![CDATA[
body {
    background-color: white;
    font-family: 'Arial', sans-serif;
	font-size: 14pt;
}

.kategoria, .towar {
	width: 800px;
	margin: 20px auto;
	padding: 10px 20px;
	background-color: #DDDDDD;
}

.kategoria {
	border: 6px outset red;
}

.towar {
	border: 6px inset blue;
}

h2 {
	color:blue;
    text-align: center;
}

.opis {
    margin: 0.5em 0;
}

.rem {
	font-style: italic;
	color: magenta;
	font-size: smaller;
}

dfn {
    font-weight: bold;
    font-style: normal;
}

.komentarz {
	color: green;
	text-style: italic;
}

]]>
        </style>
    </xsl:template>
</xsl:stylesheet>
