package gotowe.postgresql;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class P13b_Blob_Insert {

    public static void main(String[] args) {
        String[] polaGenerowane = {"photo_id"};
        String sql = "INSERT INTO photos(file_name, bytes) VALUES(?, ?)";
        
        JFileChooser fileChooser = new JFileChooser(".");
        fileChooser.setDialogTitle("Wybierz plik");
        fileChooser.setFileFilter(new FileNameExtensionFilter("Pliki graficzne", "jpg", "jpeg", "png", "bmp"));

        try(Connection c = DriverManager.getConnection(Ustawienia.URL, Ustawienia.USER, Ustawienia.PASSWD)) {
            // org.postgresql.util.PSQLException: Large Objects may not be used in auto-commit mode
            c.setAutoCommit(false);

            try(PreparedStatement stmt = c.prepareStatement(sql, polaGenerowane)) {
                while(true) {
                    int wybor = fileChooser.showOpenDialog(null);
                    if(wybor == JFileChooser.CANCEL_OPTION) break;
                    if(wybor == JFileChooser.ERROR_OPTION) continue;
                    File selectedFile = fileChooser.getSelectedFile();
                    try(InputStream input = new FileInputStream(selectedFile)) {
                        stmt.setString(1, selectedFile.getName());
                        //stmt.setBlob(2, input);
                        stmt.setBinaryStream(2, input);
                        int ile = stmt.executeUpdate();
                        try(ResultSet generatedKeys = stmt.getGeneratedKeys()) {							
                            if(ile == 1 && generatedKeys.next()) {
                                int id = generatedKeys.getInt(1);
                                JOptionPane.showMessageDialog(null, "Dodano zdjęcie " + selectedFile.getName() + " pod numerem " + id);
                            }
                        }
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            
            int wybor = JOptionPane.showConfirmDialog(null, "Czy zatwierdzasz zmiany?");
            switch(wybor) {
                case JOptionPane.YES_OPTION -> c.commit();
                case JOptionPane.NO_OPTION -> c.rollback();
            }
            JOptionPane.showMessageDialog(null, "Gotowe");
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

}
