package gotowe.postgresql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class P13a_Blob_Create {

    // nazwa typu dla danych binarnych w wielu bazach danych, w tym Oracle, to BLOB
    // w PostgreSQL ten typ nazywa się BYTEA

    public static void main(String[] args) {
        final String sql = """
                    DROP TABLE IF EXISTS photos; 
                    CREATE TABLE photos(
                        photo_id SERIAL PRIMARY KEY,
                        file_name VARCHAR(60) NOT NULL,
                        bytes BYTEA NOT NULL
                    )
                """;
        try(Connection c = DriverManager.getConnection(Ustawienia.URL, Ustawienia.USER, Ustawienia.PASSWD);
                Statement stmt = c.createStatement()) {
            stmt.execute(sql);
            System.out.println("Gotowe");
        } catch (SQLException e) {
            e.printStackTrace();
        }

    }

}
