package sklep.klient;

import java.net.MalformedURLException;
import java.net.URL;

import javax.xml.namespace.QName;

import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebEndpoint;
import jakarta.xml.ws.WebServiceClient;
import jakarta.xml.ws.WebServiceFeature;
import sklep.soap.Sklep;

@WebServiceClient(name="SklepService",
    wsdlLocation=SklepService.ADRES_WSDL,
    targetNamespace=Sklep.NAMESPACE)
public class SklepService extends Service {

    final static String ADRES_WSDL = "http://localhost:8080/wielomodulowy-soap_serwer/SklepService?wsdl";
    public final static URL WSDL_LOCATION;

    public final static QName SERVICE = new QName(Sklep.NAMESPACE, "SklepService");
    public final static QName SklepPort = new QName(Sklep.NAMESPACE, "SklepPort");
    static {
        URL url = null;
        try {
            url = new URL(ADRES_WSDL);
        } catch (MalformedURLException e) {
            System.err.println("Can not initialize the default wsdl from " + ADRES_WSDL);
        }
        WSDL_LOCATION = url;
    }

    public SklepService(URL wsdlLocation) {
        super(wsdlLocation, SERVICE);
    }

    public SklepService(URL wsdlLocation, QName serviceName) {
        super(wsdlLocation, serviceName);
    }

    public SklepService() {
        super(WSDL_LOCATION, SERVICE);
    }

    public SklepService(WebServiceFeature... features) {
        super(WSDL_LOCATION, SERVICE, features);
    }

    public SklepService(URL wsdlLocation, WebServiceFeature... features) {
        super(wsdlLocation, SERVICE, features);
    }

    public SklepService(URL wsdlLocation, QName serviceName, WebServiceFeature... features) {
        super(wsdlLocation, serviceName, features);
    }

    @WebEndpoint(name = "SklepPort")
    public Sklep getSklepPort() {
        return super.getPort(SklepPort, Sklep.class);
    }

    @WebEndpoint(name = "SklepPort")
    public Sklep getSklepPort(WebServiceFeature... features) {
        return super.getPort(SklepPort, Sklep.class, features);
    }

}
