package sklep.klient;

import java.util.Scanner;

import sklep.exn.DBException;
import sklep.exn.RecordNotFound;
import sklep.model.Product;
import sklep.soap.Sklep;

public class Klient2 {

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        SklepService service = new SklepService();
        Sklep sklep = service.getSklepPort();
        
        while(true) {
            System.out.println("Podaj ID produktu lub 0, aby zakończyć");
            int id = scanner.nextInt();
            if(id == 0) break;
            try {
                Product product = sklep.readOne(id);
                System.out.println("Znaleziono produkt: " + product.getProductName() + " za cenę " + product.getPrice());
                if(product.getDescription() != null) {
                    System.out.println("Opis: " + product.getDescription());
                }
            } catch (RecordNotFound e) {
                System.out.println("Nie ma takiego rekordu");
            } catch (DBException e) {
                System.out.println("Inny błąd: " + e);
                e.printStackTrace();
            }
        }
    }

}
