package sklep.soap;

import java.math.BigDecimal;
import java.util.List;

import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;
import sklep.exn.DBException;
import sklep.exn.RecordNotFound;
import sklep.model.Customer;
import sklep.model.Order;
import sklep.model.Product;

@WebService(name="Sklep", targetNamespace=Sklep.NAMESPACE)
public interface Sklep {
    static final String NAMESPACE = "http://sklep.alx.pl/";
    
    @WebResult(name="product")
    public List<Product> readAll() throws DBException;
    
    @WebResult(name="product")
    public List<Product> readByPrice(@WebParam(name="min") BigDecimal min, @WebParam(name="max") BigDecimal max) throws DBException;
    
    @WebResult(name="product")
    public Product readOne(@WebParam(name="id") int productId) throws DBException, RecordNotFound;
    
    public void saveProduct(@WebParam(name="product") Product product) throws DBException;
    
    @WebResult(name="customer")
    public Customer oneCustomer(@WebParam(name="email") String email) throws DBException, RecordNotFound;
    
    @WebResult(name="order")
    public Order oneOrder(@WebParam(name="id") int orderId) throws DBException, RecordNotFound;
    
    @WebResult(name="bytes")
    public byte[] getPhoto(@WebParam(name="id") int productId) throws DBException, RecordNotFound;

    public void savePhoto(@WebParam(name="id") int productId, @WebParam(name="bytes") byte[] bytes);
}
