<%@page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@taglib prefix="c" uri="jakarta.tags.core"%>
<%@taglib prefix="f" uri="http://www.springframework.org/tags/form" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Edycja danych produktu</title>
    <link rel="stylesheet" type="text/css" href="/styl.css">
</head>
<body>

<c:choose>
    <c:when test="${not empty(product.id)}">
        <h1>Edycja produktu nr ${product.id}</h1>
    </c:when>
    <c:otherwise>
        <h1>Edycja nowego produktu</h1>
    </c:otherwise>
</c:choose>

<f:form id="product-form" method="post" modelAttribute="product">
    <table class="form-tab">
        <tr>
            <td><f:label path="id">Numer:</f:label></td>
            <td><f:input path="id" placeholder="brak" type="number" readonly="true"/></td>
        </tr>
        <tr>
            <td><f:label path="productName">Nazwa towaru:</f:label></td>
            <td><f:input path="productName" placeholder="nazwa..." type="text"/>
                <f:errors path="productName" element="div" cssClass="form-error"/>
            </td>
        </tr>
        <tr>
            <td><f:label path="price">Cena:</f:label></td>
            <td><f:input path="price" placeholder="12.90" type="number" step="0.01"/>
                <f:errors path="price" element="div" cssClass="form-error"/>
            </td>
        </tr>
        <tr>
            <td><f:label path="vat">Stawka VAT:</f:label></td>
            <td><f:input path="vat" placeholder="0.23" type="number" step="0.01"/>
                <f:errors path="vat" element="div" cssClass="form-error"/>
            </td>
        </tr>
        <tr>
            <td><f:label path="description">Opis:</f:label></td>
            <td><f:textarea path="description" rows="10"/></td>
        </tr>
        <tr>
            <td><f:button>Zapisz</f:button></td>
        </tr>
    </table>
</f:form>

<div><a class="action" href="/products">powrót do listy produktów</a></div>
<div><a class="action" href="/">powrót do spisu treści</a></div>
</body>
</html>
