package sklep.security;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
public class SecurityConfig {
    // Uproszczona konfiguracja zabezpieczeń HTTP.
    // Określamy bardzo liberalną politykę autoryzacji - każdy do dostęp do każdego elementu aplikacji.
    @Bean
    SecurityFilterChain configureHttpSecurity(HttpSecurity httpSecurity) throws Exception {
        httpSecurity.authorizeHttpRequests(authz -> authz.anyRequest().permitAll());
        httpSecurity.csrf(csrf -> csrf.disable());
        
        return httpSecurity.build();
    }
    
}
