package com.example.demo.wstrzykiwanie;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class Inject2 {
    { System.out.println("Inject2 init"); }

    // 2. sposób wstrzykiwania: setter
    private Komponent komponent;
    private Repo repo;
    
    public Komponent getKomponent() {
        return komponent;
    }

    @Autowired
    public void setKomponent(Komponent komponent) {
        System.out.println("SET KOMPONENT");
        this.komponent = komponent;
    }

    public Repo getRepo() {
        return repo;
    }

    @Autowired
    public void setRepo(Repo repo) {
        this.repo = repo;
    }

    @RequestMapping("/inject2")
    @ResponseBody
    public String get() {
        return repo.getText() + " " + komponent.getValue();
    }

}
