package com.example.demo.licznik;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class Configuration8 {
    
    // Adnotacja @Bean jest używana na poziomie metody.
    // Wynik wywołania tej metody zostanie zapamiętany przez Springa i będzie traktowany jak "bean",
    // czyli zostanie wstrzyknięty tam, gdzie będzie go ktoś potrzebował.
    
    // Taka metoda musi być umieszczona w klasie, którą "przeczyta" Spring i wykona takie metody.
    // Najczęściej stosuje się klasy oznaczone @Configuration
    @Bean
    public LicznikBean8 generuj() {
        LicznikBean8 wynik = new LicznikBean8();
        wynik.setLicznik(new Licznik("bean z konfiguracji", 800));
        return wynik;
    }

}
