package com.example.demo.data;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.example.demo.model.Employee;

@Controller
@RequestMapping("/emps3")
public class Controller3 {
    /* Aby bezpośrednio w Controllerze nie używać kodów dot. Hibernate, SQL itd...
     * wydzielam operacje bazodanowe do oddzielnej klasy, opisanej jako Repository
     * i wstrzykuję referencję do repozytorium tutaj w controllerze.
     * W doatku robię to porzez interfejs (zgodne z najlepszymi praktykami Springa),
     * aby ułatwić podmianę implementacji na inną.
     */
    @Autowired
    private Repository3_Interface repository;
    
    @GetMapping
    public String showAll(Model model) {
        List<Employee> emps = repository.findAll();
        model.addAttribute("emps", emps);
        return "employees.html";
    }
    
    @GetMapping("/{id}")
    public String showOne(Model model,
            @PathVariable("id") Integer employeeId) {
        Employee emp = repository.findOne(employeeId);
        model.addAttribute("emps", List.of(emp));
        return "employees.html";
    }
    
    @GetMapping("/by_name")
    public String showByName(Model model,
            @RequestParam("name") String name) {
        List<Employee> emps = repository.findByLastName(name);
        model.addAttribute("emps", emps);
        return "employees.html";
    }
}
