package org.example.demo.waluty;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class Waluta {
    private final String kod;
    private final String nazwa;
    private final BigDecimal kurs;
    
    public Waluta(String kod, String nazwa, BigDecimal kurs) {
        this.kod = kod;
        this.nazwa = nazwa;
        this.kurs = kurs;
    }
    
    public Waluta(String kod, String nazwa, String kurs) {
        this(kod, nazwa, new BigDecimal(kurs));
    }

    public String getKod() {
        return kod;
    }

    public String getNazwa() {
        return nazwa;
    }

    public BigDecimal getKurs() {
        return kurs;
    }

    @Override
    public String toString() {
        return "Waluta [kod=" + kod + ", nazwa=" + nazwa + ", kurs=" + kurs + "]";
    }
    
    public BigDecimal przeliczNaZlote(BigDecimal kwota) {
        return kwota.multiply(kurs).setScale(2, RoundingMode.HALF_EVEN);
    }
    
    public BigDecimal przeliczNaWalute(BigDecimal kwota) {
        return kwota.divide(kurs, 2, RoundingMode.HALF_EVEN);
    }
}
